/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
            
            // make an array of the draggable symbol names
            var shapes = ['bird22','dog','fish'];
            // make an array of the droppable element names
            var targets = ['cage','dogBox','fishBox'];
            // have only the first element be draggable
            
            var Pos = [
         {'x':210,'y':428},
         {'x':346,'y':384},
         {'x':80,'y':407},
         
            ];
          k=0;
         
         
         
            //Pos.sort(function() {return 0.6 - Math.random()});
            // set up the droppable to accept each draggables
            for (i=0;i<shapes.length;i++){	
            	sym.$(shapes[i]).css({"left":Pos[i].x,"top":Pos[i].y,"position":"absolute"})
            	sym.$(shapes[i]).addClass('C'+i);
            	sym.$('.C'+i).draggable({
            	revert: 'invalid', opacity:0.35,
         
         
            	});
         
         
         
            	sym.$(targets[i]).droppable({
            		accept:'.C'+i,   // use class for accept
            		drop: handleDropEvent
         
            	});
         
         
         
         
            }
         
         
         
            function handleDropEvent(event, ui){		
                ui.draggable.draggable( 'disable' );
                $(this).droppable( 'disable' );
                // place draggable where needed. could be left, top
               // ui.draggable.position( { of: $(this), my: 'left', at: 'top' } );
                ui.draggable.position( { of: $(this), my: 'center', at: 'middle' } );
                ui.draggable.draggable( 'option', 'revert', false );
               // playsound();
               //alert(ui.draggable.attr("id"));
         
               var p = ui.draggable.attr("id");
               k++;
         
         		playsound(p);
         		checkAnimation();
         
         
         
            }
         
         
         	function checkAnimation(){
         	if (k==3){
         
                sym.getSymbol("bravo3").play();
                sym.$("resetBtn").show();
                sym.$("welldonesound")[0].play();
         
                 }
         
         
         
         	}
         
         
         	function playsound(r){
           if(r=='Stage_bird22')
           {
         
         	sym.$("bird22").hide();
         	sym.$("bird").show();
         	sym.getSymbol("cage2").play();
         
         	sym.$("cage3")[0].currentTime = 0;
         if (sym.$("cage3")[0].paused) 
         {
         	sym.$("cage3")[0].play();
         }
         
         }
         
         
         
         
            if(r=='Stage_dog')
            {
         
         	sym.$("dog").hide();
         	sym.$("dog2").show();
         sym.getSymbol("kennel").play();
         
         
         sym.$("kennel2")[0].currentTime = 0;
         if (sym.$("kennel2")[0].paused) 
         {
         	sym.$("kennel2")[0].play();
         }
         
         }
         
         
         
         if(r=='Stage_fish')
         {
         
         	sym.$("fish").hide();
         	sym.$("fish2").show();
         	sym.getSymbol("aqua").play();
         
         
         sym.$("aquarium")[0].currentTime = 0;
         if (sym.$("aquarium")[0].paused) 
         {
         	sym.$("aquarium")[0].play();
         }
         
         
         }
         
         
         
         
         }
         
         
            sym.$('resetBtn').click(function(){
            	window.location.reload()
            });
         
         
         
         

      });
      //Edge binding end

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$("dog2").hide();
         sym.$("fish2").hide();
         sym.$("bird").hide();

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'title'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.stop()

      });
      //Edge binding end

   })("title");
   //Edge symbol end:'title'

   //=========================================================
   
   //Edge symbol: 'bravo3'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1385, function(sym, e) {
         sym.stop()

      });
      //Edge binding end

   })("bravo3");
   //Edge symbol end:'bravo3'

   //=========================================================
   
   //Edge symbol: 'aqua'
   (function(symbolName) {   
   
   })("aqua");
   //Edge symbol end:'aqua'

   //=========================================================
   
   //Edge symbol: 'cage'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.stop()

      });
      //Edge binding end

   })("cage");
   //Edge symbol end:'cage'

   //=========================================================
   
   //Edge symbol: 'kennel'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.stop()

      });
      //Edge binding end

   })("kennel");
   //Edge symbol end:'kennel'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "EDGE-22184378");