/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
            
            // make an array of the draggable symbol names
            var shapes = ['pup','bir','rab','tor','kit','fis'];
            // make an array of the droppable element names
            var targets = ['puppyBox','birdBox','rabbitBox','tortoiseBox','kittenBox','fishBox'];
            // have only the first element be draggable
            
            var Pos = [
         {'x':88,'y':59},
         {'x':209,'y':59},
         {'x':200,'y':100},
         {'x':307,'y':59},
         {'x':330,'y':100},
         {'x':88,'y':100},
         
            ];
          k=0;
         
         
         
            //Pos.sort(function() {return 0.6 - Math.random()});
            // set up the droppable to accept each draggables
            for (i=0;i<shapes.length;i++){	
            	sym.$(shapes[i]).css({"left":Pos[i].x,"top":Pos[i].y,"position":"absolute"})
            	sym.$(shapes[i]).addClass('C'+i);
            	sym.$('.C'+i).draggable({
            	revert: 'invalid', opacity:0.35,
         
         
            	});
         
         
         
            	sym.$(targets[i]).droppable({
            		accept:'.C'+i,   // use class for accept
            		drop: handleDropEvent
         
            	});
         
         
         
         
            }
         
         
         
            function handleDropEvent(event, ui){		
                ui.draggable.draggable( 'disable' );
                $(this).droppable( 'disable' );
                // place draggable where needed. could be left, top
               // ui.draggable.position( { of: $(this), my: 'left', at: 'top' } );
                ui.draggable.position( { of: $(this), my: 'center', at: 'middle' } );
                ui.draggable.draggable( 'option', 'revert', false );
               // playsound();
               //alert(ui.draggable.attr("id"));
         
               var p = ui.draggable.attr("id");
               k++;
         
         		playsound(p);
         		checkAnimation();
         
         
         
            }
         
         
         	function checkAnimation(){
         	if (k==6){
         
                sym.getSymbol("bravo3").play();
                sym.$("resetBtn").show();
                sym.$("welldonesound")[0].play();
         
                 }
         
         
         
         	}
         
         
         	function playsound(r)
         
         	{
           if(r=='Stage_pup')
           {
         
         	sym.$("puppy33").hide();
         	sym.$("puppy22").show();
         	
         		sym.$("Puppy")[0].currentTime = 0;
         if (sym.$("Puppy")[0].paused) 
         {
         	sym.$("Puppy")[0].play();
         }
         
         
         }
         
         
         
         
            if(r=='Stage_bir')
            {
         
         	sym.$("bird33").hide();
         	sym.$("bird23").show();
         	
         	
         	sym.$("bird")[0].currentTime = 0;
         if (sym.$("bird")[0].paused) 
         {
         	sym.$("bird")[0].play();
         }
         
         
         }
         
         if(r=='Stage_rab')
         {
         
         	sym.$("rabbit33").hide();
         	sym.$("rabbit22").show();
         	
         	sym.$("Rabbit")[0].currentTime = 0;
         if (sym.$("Rabbit")[0].paused) 
         {
         	sym.$("Rabbit")[0].play();
         }
         
         
         
         }
         
         if(r=='Stage_tor')
           {
         
         	sym.$("turtle33").hide();
         	sym.$("turtle").show();
         	
         		sym.$("tortoise")[0].currentTime = 0;
         if (sym.$("tortoise")[0].paused) 
         {
         	sym.$("tortoise")[0].play();
         }
         
         }
         
         
         if(r=='Stage_kit')
           {
         
         	sym.$("kitten33").hide();
         	sym.$("kitten22").show();
         	
         			sym.$("kitten")[0].currentTime = 0;
         if (sym.$("kitten")[0].paused) 
         {
         	sym.$("kitten")[0].play();
         }
         	
         	
         
         }
         
         if(r=='Stage_fis')
           {
         
         	sym.$("fish33").hide();
         	sym.$("fish22").show();
         
          			sym.$("fish")[0].currentTime = 0;
         if (sym.$("fish")[0].paused) 
         {
         	sym.$("fish")[0].play();
         } 
           
           
           
         }
         }
         
         
            sym.$('resetBtn').click(function(){
            	window.location.reload()
            });
         
         
         
         

      });
      //Edge binding end

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$("puppy22").hide();
         sym.$("fish22").hide();
         sym.$("bird23").hide();
         sym.$("rabbit22").hide();
         sym.$("turtle").hide();
         sym.$("kitten22").hide();

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'title'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.stop()

      });
      //Edge binding end

   })("title");
   //Edge symbol end:'title'

   //=========================================================
   
   //Edge symbol: 'bravo3'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1385, function(sym, e) {
         sym.stop()

      });
      //Edge binding end

   })("bravo3");
   //Edge symbol end:'bravo3'

   //=========================================================
   
   //Edge symbol: 'aqua'
   (function(symbolName) {   
   
   })("aqua");
   //Edge symbol end:'aqua'

   //=========================================================
   
   //Edge symbol: 'cage'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.stop()

      });
      //Edge binding end

   })("cage");
   //Edge symbol end:'cage'

   //=========================================================
   
   //Edge symbol: 'kennel'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.stop()

      });
      //Edge binding end

   })("kennel");
   //Edge symbol end:'kennel'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "EDGE-22184378");